#!/usr/bin/wish
# the procedures controlling the behavior of the table are taken from
# "Practical programming in Tcl and Tk" from B. Welch

proc Scroll_Set {scrollbar geoCmd offset size} {
    if {$offset != 0.0 || $size != 1.0} {
	eval $geoCmd			;# Make sure it is visible
	$scrollbar set $offset $size
    } else {
	set manager [lindex $geoCmd 0]
	$manager forget $scrollbar
	# hide it
    }
}

proc ScrollCanvas { top } {
    # Create a scrolling canvas
    canvas $top.canvas -width 10 -height 10 \
	-yscrollcommand [list Scroll_Set $top.yscroll \
	 [list pack $top.yscroll -side right -fill y]]
    scrollbar $top.yscroll -orient vertical \
	-command [list $top.canvas yview]
    pack $top.yscroll -side right -fill y
    pack $top.canvas -side left -fill both -expand true
}

proc keySelect { i frame inc max } {
    incr i $inc
    if {$i<0} {set i 0}
    if {$i>=$max} {set i $max}
    regsub {(.*)\..*$} $frame {\1} canvas
    # get canvas via regexp
    set offset [$canvas yview]
    regexp {([^ ]+) (.*)} $offset -match a b
    # scrollbar position between a and b
    set b [expr {$b - 1/"$max.0"}]
    # set limit "one up" against rounding problems
    set goal [expr {$i/"$max.0"}]
    if {$inc == 1} {
	# scroll down, scroll such that entry is at top
	if {$goal >= $b} {
	    $canvas yview moveto $goal
	}
    } else {
	if {$goal <= $a} {
	    # scroll up, scroll such that entry is at bottom
	    $canvas yview moveto $goal
	}
    }
    # where to scroll to
    select $i $frame $max
}

proc Scrolled_EntrySet { canvas titles labels entries } {
    # Create one frame to hold everything
    # and position it on the canvas
    event add <<Ok>> \
	<Return> <Meta-Return> <Alt-Return> <Control-Return> <Command-Return>
    event add <<Cancel>> <Escape>
    set f [frame $canvas.f -bd 0]
    $canvas create window 0 0 -anchor nw -window $f
    # pack $f -expand true -fill x
    # fills also status bar, and disables scrolling
    # Create and grid the labeled entries
    set i 0
    label $f.labelT1 -text [lindex $titles 0]
    label $f.labelT2 -text [lindex $titles 1]
    grid $f.labelT1 $f.labelT2
    set max [expr [llength $labels]-1]
    foreach label $labels {
	set entry [lindex $entries $i]
	label $f.label$i -text $label
	entry $f.entry$i -relief sunken -text $entry -width 30
	$f.entry$i insert 0 $entry
	grid $f.label$i $f.entry$i
	grid $f.label$i -sticky w
	grid $f.entry$i -sticky news
	grid columnconfigure $f 1 -weight 1
	bind $f.entry$i <<Cancel>> [list cancel $i $f]
	bind $f.entry$i <<Ok>> [list ok $i $f]
	bind $f.entry$i <Button-1> [list select $i $f $max]
	bind $f.entry$i <Up> \
	    [list keySelect $i $f -1 $max]
	bind $f.entry$i <Down> \
	    [list keySelect $i $f 1 $max]
	bind $f.entry$i <Tab> \
	    [list keySelect $i $f 1 $max]
	# popup menu
	set popup .popup$i
	menu $popup -tearoff false
	$popup add command -label "Insert Directory..." \
	    -command [ list getDirectory $f.entry$i ]

	bind $f.entry$i <Button-3> [list tk_popup $popup %X %Y]
	incr i
    }

    set child $f.entry0
    
    # Wait for the window to become visible and then
    # set up the scroll region based on
    # the requested size of the frame, and set 
    # the scroll increment based on the
    # requested height of the widgets
    
    tkwait visibility $child
    set bbox [grid bbox $f 0 0]
    set incr [lindex $bbox 3]
    incr incr 2
    # padding
    set width [winfo reqwidth $f]
    set height [winfo reqheight $f]
    $canvas config -scrollregion "0 0 $width $height"
    $canvas config -yscrollincrement $incr
    set max [llength $labels]
    if {$max > 10} {
	set max 10
    }
    set height [expr $incr * $max]
    $canvas config -width $width -height $height
}

