#!/usr/bin/wish
###################################################
# Variable editor, v1.0.1
# by Cyrille Artho, distributed under the GPL
# takes definitions like variable\tvalue[\tdescription]
# shows these entries graphically and lets the user change them

set dir "/usr/local/htmlplain"; # directory where the program is installed
set confdir "$env(HOME)/.htmlplain";     # directory with settings
set dotdir $confdir
set conffile "config.pl"
source [file join "$dir/twolists.tcl"]
source [file join "$dir/common.tcl"]
# parts common to both variable and template editor
source [file join "$dir/colorpicker.tcl"]
namespace import Colorpicker::tk_getColor

proc loadConfig { list1 list2 } {
    global descriptions lines hasChanged fileName insert
    set insert 0
    # insert = insertion mode
    set hasChanged 0
    if [catch {open [file join $fileName] r} configFile] {
	puts stderr "Cannot open $fileName"
	return 1
    } else {
	# read the file
	while {[gets $configFile line] >= 0} {
	    if { [regexp {^\#} $line] } {
		lappend lines $line
	    } else {
		if [regexp "(\[^\t\]*)\t(.*)" $line match variable value] {
		    if [regexp "(\[^\t\]*)\t(.*)" $value match value comment] {
			regsub {^\# *} $comment {} comment
			lappend descriptions $comment
		    } else {
			lappend descriptions {}
		    }
		    $list1 insert end $variable
		    $list2 insert end $value
		    # settings are now stored in lists variables, values, comments
		}
	    }
	}
	close $configFile
    }
    setTitle $fileName
    return 0
}

proc setTitle { filename } {
    if {$filename != ""} {
	wm title . "Variable editor - $filename"
    } else {
	wm title . "Variable editor"
    }
}

proc replaceValue { currentline val } {
    global body
    $body.values delete $currentline
    $body.values insert $currentline $val
}

proc GetInput1 { } {
    global input
    set var [$input.ne get]
    return $var
}

proc GetInput2 { } {
    global input
    set val [$input.me get]
    return $val
}

proc GetInput3 { } {
    global input
    return [$input.se get]
}


proc PutInput2 { text } {
    global input
    $input.me insert 0 $text
}

proc focusInput2 { } {
    global input
    focus $input.me
}

proc EmptyInput { input } {
    $input.ne delete 0 end
    $input.me delete 0 end
    $input.se delete 0 end
}

proc checkInput { lbox var val currentline } {
    global insert
    global input
    if {$var == "" && $val == ""} { return 1 }
    if {$var == "" } {
	focusInput1
	status_warn "Please enter a variable name."
	# force user to complete all fields
	return 1
    }
    if {$val== "" } {
	focusInput2
	status_warn "Please enter a value."
	# force user to complete all fields
	return 1
    }
    for {set i 0} {$i < [$lbox.variables index end]} {incr i} {
	set tmpvar [$lbox.variables get $i]
	if { ![string compare $tmpvar $var] } {
	    if {$i != $currentline || $insert} {
		status_warn "Variable name already exists, choose a different one."
		focusInput1
		return 1
	    }
	}
    }
    return 0
}

proc Quit { } {
    global dotdir
    # save workspace state and really quit
    if [catch {open [file join "$dotdir/.variable"] w} configFile] {
#	puts stderr "Cannot open $dotdir/.variable"
	exit 1
    } else {
	puts $configFile [wm geometry . ]
	close $configFile
	exit
    }
}

proc about { } {
    tk_messageBox -type ok -default ok \
	-message "Variable editor v1.0.1\nWritten by Cyrille Artho" \
	-icon info
}

proc getFilename { w } {
    global input
    set entry $input.$w
    append entry "e"
    set f ""
    if {[$entry select present]} {
	set f [$entry get]
	set start [$entry index sel.first]
	set end [$entry index sel.last]
	set f [string range $f $start $end]
	set f [string trim $f]
	if {![file exists $f]} {
	    set f ""
	}
    }
    # try later to set it to value after cursor, if valid ([^ ]+)
    set typelist {
	{"HTML Files" {".html" ".shtml"}}
	{"All Files" {"*"}}
    }
    set out \
	[tk_getOpenFile -filetypes $typelist \
	     -title "Choose filename" -initialfile $f]
    if {$out != ""} {
	$entry delete $start $end
    }
    $entry insert insert $out
}

proc getColor { w } {
    global input
    set entry $input.$w
    append entry "e"
    set c ""
    if {[$entry select present]} {
	set c [$entry get]
	set c [string range $c \
		   [$entry index sel.first]\
		   [expr {[$entry index sel.last]-1}]]
    }
    set a ""
    set b ""
    regexp {(\"?\#?)(......)(\"?)} $c -match a c b
    # try to set it to value after cursor, if valid ([0-9a-fA-F]{6})
    if {![regexp "^\[0-9a-fA-F\]+\$" $c] \
	    || [string length $c] != 6} {set c "ff0000"}
    set out [Colorpicker::tk_getColor $c]
    if {$out != ""} {
	if {[$entry get] == ""} {
	    set out "\"\#$out\""
	} else {
	    catch {$entry delete sel.first sel.last}
	    set out "$a$out$b"
	}
	$entry insert insert $out
    }
}

proc help {} {
    global dir
    set help [file join "$dir/help/config/help.shtml"]
    if [catch {exec "netscape" $help &} ] {
	 tk_messageBox -type ok -default ok \
	-message "Could not start Netscape.\nPlease open the help page 'help.html' in Netscape." \
	-icon error
    }
}

proc createMainWindow { } {
    global body input typelist fileName hasChanged dotdir menubar
    wm title . "Variable Editor"
    # create frames to hold content
    #frame .menubar
    frame .input
    frame .body
    frame .status
    set menubar .menubar
    set input .input
    set body .body
    set status .status
    set padding 2
    event add <<FocusVar>> <Meta-v> <Alt-v> <Control-v> <Command-v>
    event add <<FocusVal>> <Meta-a> <Alt-a> <Control-a> <Command-a>
    set accKey [initBindings $body $input]
    # create menu
    menu $menubar
    . config -menu $menubar
    foreach { name } \
    { File Edit Help } {
	set $name [menu $menubar.m$name]
	$menubar add cascade -label $name \
	    -underline 0 -menu $menubar.m$name
    }
#    $menubar add cascade -label Help -underline 0 -menu $menubar.help
    foreach { name label pos acc } \
	{ New "New..." 0 N Open "Open..." 0 O reload Revert 0 R \
	      save Save 0 S saveAs "Save As..." 5 A quit Exit 1 X } {
		  $File add command -label $label \
		      -underline $pos -command $name -accelerator "$accKey$acc"
	}
    set accK $accKey
    append accK "Z"
    $Edit add command -label Undo -accelerator $accK \
	-underline 0 -command {undo $body $input}
    $Edit add separator
    foreach { name label pos acc } \
	{ {addEntry $body $input} "Add Entry" 0 Insert \
	      {delete $body $input} "Delete Entry" 0 Delete } {
	$Edit add command -label $label -accelerator "$accKey$acc" \
	    -underline $pos -command $name
	}
    foreach { name label pos acc } \
	{ about About... 0 "" help Help 0 F1} {
	    if {[string compare $acc ""]} {
		$Help add command -label $label -accelerator "$acc" \
		    -underline $pos -command $name
	    } else {
		$Help add command -label $label \
		    -underline $pos -command $name
	    }
	}

    # input frame
    label $input.nw -text Variable -justify left -underline 0
    entry $input.ne -relief sunken
    label $input.mw -text Value -justify left -underline 1
    entry $input.me -relief sunken
    label $input.sw -text Comment -justify left
    entry $input.se -relief sunken
    button $input.ok -text Ok -command [list ok $body $input] -underline 1
    set e e
    set w w
    foreach ypos { n m s } {
	# grid row
	grid $input.$ypos$w $input.$ypos$e -padx $padding -pady $padding -sticky w
	grid $input.$ypos$e -sticky ew

	# popup menu
	set popup .popup$ypos
	menu $popup
	$popup add command -label "Insert Color..." \
	    -command [ list getColor $ypos ]
	$popup add command -label "Insert Filename..." \
	    -command [ list getFilename $ypos ]
	$popup add separator
	$popup add command -label "Cancel changes" -command { cancel $body $input }
	bind $input.$ypos$e <Button-3> [list tk_popup $popup %X %Y]
    }

    grid columnconfigure $input 1 -weight 1
    grid $input.ok -row 0 -column 2 -rowspan 3 -sticky news -padx 2
    event add <<Ok>> <Control-k> <Alt-k> <Meta-k> \
	<Return> <Meta-Return> <Alt-Return> <Control-Return> <Command-Return>
    bind $input.ne <<Ok>> {ok $body $input; break }
    bind $input.me <<Ok>> {ok $body $input; break }
    bind $input.se <<Ok>> {ok $body $input; break }
    bind $input.ne <<Add>> {addEntry $body $input; break }
    bind $input.me <<Add>> {addEntry $body $input; break }
    bind $input.se <<Add>> {addEntry $body $input; break }
    bind $input.ne <<Delete>> {delete $body $input; break }
    bind $input.me <<Delete>> {delete $body $input; break }
    bind $input.se <<Delete>> {delete $body $input; break }

    createBody $body $input $padding "List of variables" Value
    # create status frame content
    label $status.msg -justify left \
	-text "Please wait while loading the variables ..."

    pack $status.msg -side left -fill x -anchor w -padx $padding  -pady $padding
    # pack frames
    #pack $menubar -fill x -padx $padding  -pady $padding
    pack $input -fill x -anchor w
    pack $body -expand true -fill both
    pack $status -fill both -anchor w

    set typelist {
	{"Text Files" {".txt"}}
	{"All Files" {"*"}}
    }
    wm protocol . WM_DELETE_WINDOW quit
    wm minsize . 25 10
    # load workspace state
    if  { ![catch {open [file join "$dotdir/.variable"] r} configFile]} {
	wm geometry . [gets $configFile]
	close $configFile
    }
    # load configuration
    set hasChanged 0
    if {[info exists fileName]} {
	if {[loadConfig $body.variables $body.values]} {
	    if {[Open]} {
		clearEntries
	    }
	}
    } else {
	clearEntries
    }
    status_ok
    setTitle $fileName
}

if {[file exists [file join "./$conffile"]]} {
    set confdir "."
    # prefer local config file
}
if [catch {open [file join "$confdir/$conffile"] r} configFile] {
	puts stderr "Cannot open $confdir/$conffile"
	return 1
    } else {
	while {[gets $configFile line] >= 0} {
	    if {[regexp "variableFile *= *'(.*)'" \
		     $line -match fileName]} {
	    }
	}
    }
createMainWindow
focus $body.variables
trace variable hasChanged w traceChanges
