#########################################################################
# Buffered printing
# written in 1998/99 by Cyrille Artho, published under the GPL
# entries in buffer must not necessarily be lines

my @buffer;

sub clearBuffer {
  undef @buffer;
}

sub printToBuffer {
  push @buffer, @_;
}

sub printBuffer {
  print @buffer;
}

sub printBufferToFile { # arg1 = filename
  my $filename = shift @_;
  my $err = 0;
  unless (open(OUTPUT, ">$filename")) {
    $err = 1;
    if ($! =~ /No.*directory/i) {
      unless (mkdir dirname($filename),0777) {
	&error ("Could not create directory $filename: $!");
      }
      if (open(OUTPUT, ">$filename")) {
	$err = 0;
      }
    }
    if ($err) {
      &error ("Could not open file $filename for writing: $!");
    }
  }
  print OUTPUT @buffer;
  close OUTPUT;
}

sub bufferUngetch { # remove last character of last line in buffer
  chop $buffer[$buffer - 1];
}

sub getBufSize {
  return scalar @buffer;
}

sub getBufEntry { # get line from buffer
  if ($_[0] >= scalar @buffer) { return undef; }
  elsif ($_[0] < 0) { return undef; }
  else { return $buffer[$_[0]]; }
}

sub insertline { # insert lines at line number (arg1 = lineno, args = lines)
  my $lineno = shift @_;
  splice (@buffer, $lineno, 0, @_);
}

sub replaceline { # replace line (number) with line
  $buffer[$_[0]]=$_[1];
}

sub removeline { # remove line (number) from buffer
  splice (@buffer, $_[0], 1);
}

sub unquoteLine {
  $_[0] =~ tr/\001/\"/;
}

sub unquoteBuffer { # tr/// command within buffer
  my $line;
  foreach $line (@buffer) {
    &unquoteLine($line);
  }
}

sub quoteLine {
  s/\\\"/\001/g;                       # replace escape+" (\") with token
}
1;
