namespace eval Colorpicker {

    proc createColors { frame size } {
	set red 0
	
	for {set row 0} {$row < 5} { incr row } {
	    if {$row == 4} { set size [expr {$size/2}] }
	    for {set col 0} {$col < 7} { incr col } {
		if {$row % 2 != 0 && $col % 2 != 0} {
		    frame "$frame.$row$col" -width $size -height $size
		    grid "$frame.$row$col" -row $row -column $col -sticky news
		    create6x6 "$frame.$row$col" $red $size
		    incr red
		} else {
		    frame "$frame.$row$col" -width $size -height $size
		    grid "$frame.$row$col" -row $row -column $col
		}
	    }
	}
	grid columnconfigure $frame 1 -weight 1
	grid columnconfigure $frame 3 -weight 1
	grid columnconfigure $frame 5 -weight 1
	grid rowconfigure $frame 1 -weight 1
	grid rowconfigure $frame 3 -weight 1
    }
    
    proc create6x6 { frame red size } {
	set x { $red % 153 }
	set x { $x / 51 }
	# get x pos = [0..2] from red value
	for { set green 0 } { $green < 6 } { incr green } {
	    for { set blue 0 } { $blue < 6 } { incr blue } {
		set bg [format "#%02x%02x%02x" \
			    [expr {$red*51}] \
			    [expr {$green*51}] \
			    [expr {$blue*51}]]
		frame "$frame.$green$blue" \
		    -bg $bg -width $size -height $size -borderwidth 2
		#		    -activebackground $bg
		grid "$frame.$green$blue" -row $blue -column $green \
		    -sticky news
		bind "$frame.$green$blue" <Enter> \
		    [list "$frame.$green$blue" configure -relief raised]
		bind "$frame.$green$blue" <Leave> \
		    [list Colorpicker::colorLeave $red $green $blue]
		bind "$frame.$green$blue" <Button-1> \
		    [list Colorpicker::colorSelect $red $green $blue]
	    }
	    grid columnconfigure $frame $green -weight 1
	    grid rowconfigure $frame $green -weight 1
	}
    }
    
    proc colorLeave { red green blue } {
	global old main
	set y0 [expr { 2*($red % 3)+1 }]
	set x0 [expr { 2*($red / 3)+1 }]
	set x $green
	set y $blue
	if {[info exists old] && $old == "$main.$x0$y0.$x$y"} {
	    "$main.$x0$y0.$x$y" configure -relief sunken
	} else {
	    "$main.$x0$y0.$x$y" configure -relief flat
	}
    }
    
    proc colorSelect { red green blue } {
	global bottom old main
	$bottom.input delete 0 end
	set bg [format "%02x%02x%02x" \
		    [expr {$red*51}] \
		    [expr {$green*51}] \
		    [expr {$blue*51}]]
	$bottom.input insert insert $bg
	$bottom.col configure -bg "\#$bg"
	if [info exists old] {
	    $old configure -relief flat
	}
	set y0 [expr { 2*($red % 3)+1 }]
	set x0 [expr { 2*($red / 3)+1 }]
	set x $green
	set y $blue
	set old "$main.$x0$y0.$x$y"
	$old configure -relief sunken
    }
    
    proc colorInput { } {
	global bottom old main color
	set color [$bottom.input get]
	if {[regexp "^\[0-9A-Fa-f\]+\$" $color] && \
		[string length $color] == 6} {
	    $bottom.col configure -bg "\#$color"
	    set format "%2x%2x%2x"
	    scan $color $format red green blue
	    set red [expr {($red + 25)/51}]
	    set green [expr {($green + 25)/51}]
	    set blue [expr {($blue + 25)/51}]
	    if [info exists old] {
		$old configure -relief flat
	    }
	    set y0 [expr { 2*($red % 3)+1 }]
	    set x0 [expr { 2*($red / 3)+1 }]
	    set x $green
	    set y $blue
	    set old "$main.$x0$y0.$x$y"
	    $old configure -relief sunken
	} else {
	    tk_messageBox -type ok -icon error \
		-message "Invalid color."
	}
    }
    
    proc ok { } {
	global bottom finished color
	set color [$bottom.input get]
	if {[regexp "^\[0-9A-Fa-f\]+\$" $color] && \
		[string length $color] == 6} {
	    set finished 1
	} else {
	    tk_messageBox -type ok -icon error \
		-message "Invalid color."
	}
    }
    
    proc createWindows { root } {
	global bottom main    
	set main $root.main
	set bottom $root.bottom
	frame $main
	frame $bottom
	createColors $main 16
	frame $bottom.col -width 100 -bg white \
	    -height 32 -borderwidth 2 -relief sunken
	label $bottom.hash -text "#"
	entry $bottom.input -width 6 -text ffffff
	bind $bottom.input <Return> { Colorpicker::colorInput }
	button $bottom.ok -text "Ok" -command Colorpicker::ok
	button $bottom.cancel -text "Cancel" -command { 
	    set color ""
	    set finished 1 
	}
	pack $bottom.col $bottom.hash $bottom.input \
	    $bottom.ok $bottom.cancel -padx 6 -pady 2 -side left
	pack $bottom.col -fill both  -expand true -pady 6 -padx 8
	pack $bottom.hash -padx 0 -ipadx 0 -anchor e
	
	pack $main -expand true -fill both
	pack $bottom -fill x -padx 8 -pady 2
    }
    
    proc tk_getColor { args } {
	global root bottom finished color
	set color "ffffff"
	set root .color
	toplevel $root
	grab set $root
	createWindows $root
	$bottom.input delete 0 end
	wm title $root "Color Picker"
	if {[lindex $args 0] != ""} {
	    set color [lindex $args 0]
	    if {[regexp "^\[0-9A-Fa-f\]+\$" $color] && \
		    [string length $color] == 6} {
		$bottom.input insert insert $color
		colorInput
		tkwait variable finished
	    }
	}
	destroy $root
	catch {unset finished}
	set retval $color
	unset color
	return $retval 
    }
}
