#!/usr/bin/perl
##############################################################
# Configurations for Perl files
# written in 1998/99 by Cyrille Artho, published under the GPL

# "all"
$MAX_LENGTH = '32767';                 # Maximum line length
$verbose = '0';                        # verbosity level (0 or 1)
$variableNames = 'title';              # 'Magic' tags (without angular brackets) that can set variables

# parser.pl
$templateFile = 'template.html';       # Template file name
$variableFile = 'variables.txt';       # Variable file name
$root = '/usr/local/htmlplain/example'; # Path of documents to be parsed
$outputPath = '~/upload';              # Path for files to be uploaded
$killTags = 'address';                 # Remove everything here between <tag> and </tag>
$macros = 'SiteMap, MakeLinks, DumpArgs, LinkTable, Pictures, Back, LinkTo'; # Names of trusted macros
$searchPat = '(Last modified.*)|(<!-- hhmts.*-->)'; # These entries will be searched for ...
$replacePat = '';                      # And replaced by this (one line only)
$fastHeader = '0';                     # 1 = do not try to override header lines by document
$fastFooter = '0';                     # 1 = do not try to override footer lines by document
$glueHeader = 'body';                  # "glue" rest of header lines to this one
$glueFooter = '/body';                 # "glue" rest of footer lines to this one
$quoteVars = '1';                      # put quotes around special variables (e. g. filename)

# filetable.pl
$filter = 'html$';                     # Filter for documents: html$ = html, phtml or shtml, but not *html~
$imageFilter = '\.(gif|jpe?g|png)$';   # Filter for image files
$binaries = '\.(tar|gz|ps|rpm|zip|css)$'; # filter for binaries (e. g. .tar.gz)
$exclude = '(\.(pl|cgi)$)|(template\.html)'; # Exclude these documents from parsing
$hide = '';        # Pages that do not appear on site maps etc.
$imageIdentifier = 'identify';         # Image identifier equal to UNIX identify
$startPat = '<title>';                 # Pattern that occurs before document title
$endPat = '<\/title>';                 # Pattern after document title, "\/" = "/"
$fileTable = 'filetable.txt';          # File where to store file table
$sizeDiv = '1024';                     # Divisor for file size - should be 1 or 1024
$sizeSuffix = 'KB';                    # Suffix for file size - should be none or KB

# parsing.pl
# URLify
$urls = '(http|telnet|gopher|file|wais|ftp)'; # Set of valid URL protocols
$punc = '.,;:!?\-';                    # Punctuation characters
$any = '\w/#~:.?+=&%@!\-';             # Any character, \w = letters and numbers
1;
