#!/usr/bin/wish

proc install { } {
    global program data netscape env perl wish
    global program_std data_perl data_tcl netscape_std
    global perl_std wish_std
    if {[dir_check $program] || [dir_check $data]} {
	return 1
    }
    regsub ^$env(HOME)/ $data {$ENV{HOME}".$slash."} perl_data
    regsub ^$env(HOME)/ $data {$env(HOME)/} tcl_data
#    regsub -all -- {\\} $perl_data {/} perl_data
    foreach match [glob -- "*.pl"] {
	if {$match != "config.pl"} {
	    set filename [file join $program $match]
	    puts stdout $filename
	    if [catch {file copy -force $match $filename}] {
		puts stderr "Could not copy $filename."
		set error 1
	    }
	}
    }
    foreach infile { "CHANGELOG" "COPYING" "REAMDE" "TODO" \
			 "example" "help" "screenshots" "manual.ps"} {
	set filename [file join $program $infile]
	puts stdout $filename
	if [catch {file copy -force $infile $filename}] {
	    puts stderr "Could not copy $filename."
	    set error 1
	}
    }
    # other Perl files: include replacements
    foreach infile {"converter" "htmlplain" \
			"latex2htmlinc" "plainfiles"} {
	set filename [file join $program $infile]
	if [catch {open [file join $infile] r} file] {
	    puts stderr "Cannot open $infile."
	    exit 1
	}
	puts stdout $filename
	if [catch {open $filename w} file2] {
	    puts stderr "Cannot open $filename for writing."
	    exit 1
	}
	while {[gets $file line] >= 0} {
	    regsub $perl_std $line $perl line
	    regsub $program_std $line $program line
	    regsub $data_perl $line $perl_data line
	    puts $file2 $line
	}
	close $file
	close $file2
    }
    # Tcl files: include replacements
    foreach infile [glob -- "*.tcl"] {
	set filename [file join $program $infile]
	if [catch {open [file join $infile] r} file] {
	    puts stderr "Cannot open $infile."
	    exit 1
	}
	puts stdout $filename
	if [catch {open $filename w} file2] {
	    puts stderr "Cannot open $filename for writing."
	    exit 1
	}
	while {[gets $file line] >= 0} {
	    regsub $wish_std $line $wish line
	    regsub $program_std $line $program line
	    regsub $data_tcl $line $tcl_data line
	    regsub $netscape_std $line $netscape line
	    puts $file2 $line
	}
	close $file
	close $file2
    }
    # config files: copy to data dir
    foreach infile { "config.pl" "template.html" "variables.txt" } {
	set filename [file join $data $infile]
	puts stdout $filename
	set choice "yes"
	if {[file exists $filename]} {
	    set choice [tk_messageBox -type yesno -default no \
			    -message "Overwrite $filename?" \
			    -icon question]
	}
	if {$choice == "yes"} {
	    if [catch {file copy -force $infile $filename}] {
		puts stderr "Could not copy $filename."
		set error 1
	    }
	}
    }
    if [info exists error] {
	tk_messageBox -type ok -default ok \
	    -message "Some minor errors occured, check console log." \
	    -icon info
    }
    tk_messageBox -type ok -default ok \
	-message "Installation successful." \
	-icon info
    exit
}

proc dir_check { dir } {
    if {![file exists $dir]} {
	set choice [tk_messageBox -type yesno -default yes \
			-message "Directory $dir does not exist - create?" \
			-icon question]
	if {$choice == "no"} {
	    return 1
	}
	if [catch {file mkdir [file join $dir]}] {
	    tk_messageBox -type ok -default ok \
		-message "Could create directory $dir." \
		-icon error
	    return 1
	}
    }
    if {![file isdirectory $dir]} {
	tk_messageBox -type ok -default ok \
	    -message "File $dir is not a directory." \
	    -icon error
	return 1
    }
    if {![file writable $dir]} {
	tk_messageBox -type ok -default ok \
	    -message "Directory $dir is not writable." \
	    -icon error
	return 1
    }
    return 0
}

wm title . "HTML PLAIN installer"
# create frames to hold content
set top .top
set main .main
set bottom .bottom
set program [file join "/usr/local/htmlplain"]
set data [file join "$env(HOME)/.htmlplain"]
set netscape "netscape"
set perl "/usr/bin/perl"
set wish "/usr/bin/wish"
set program_std "/usr/local/htmlplain"
set perl_std "/usr/bin/perl"
set wish_std "/usr/bin/wish"
set data_perl {\$ENV{HOME}".\$slash.".htmlplain}
set data_tcl {\$env\(HOME\)/.htmlplain}
set netscape_std "netscape"

frame $top
frame $main
frame $bottom
set padding 3
label $top.title -text "Welcome to HTML PLAIN." \
    -relief solid -padx 4 -pady 4 -borderwidth 2
grid $top.title -columnspan 2 -pady 5 -padx 5
pack $top -padx $padding -pady $padding

event add <<Go>> <Meta-i> <Alt-i> <Control-i> <Command-i>
event add <<Exit>> \
	<Meta-x> <Alt-x> <Control-x> <Control-c> <Command-period>
bind . <<Exit>> exit
bind . <<Go>> { install }

# create all input entries
foreach { name label } \
    { program "Program directory" data "Data directory" \
      netscape "Path for Netscape" perl "Path for perl" \
      wish "Path for wish" } {
	  label $main.label$name -text $label
	  pack $main.label$name -anchor w
	  entry $main.entry$name -textvariable $name
	  pack $main.entry$name -anchor w -fill x
    }
pack $main -expand true -padx $padding -pady $padding

# create all buttons
foreach { name label pos } \
    { install "Install" 0 exit "Exit" 1 } {
	button $bottom.$name -text $label -command $name -underline $pos
	pack $bottom.$name -side left
    }
pack $bottom -padx $padding -pady $padding
$main.entryprogram select range 0 end
focus $main.entryprogram
