#!/usr/bin/perl
###########################################################
# Parser for file table
# written in 1999 by Cyrille Artho, published under the GPL

my (@filetable, @HTMLfiles, @HTMLfilenames);
my $sortingCode;

sub parseFileTable { # arg1 = filename of filetable, arg2 = ref_to_storage
  # arg3 = ref_to_array with (full) HTML filenames
  my $filename = shift @_;
  my $table = shift @_;
  my $ref_to_array = shift @_;

  unless (open(FILETABLE, $filename)) {
    &error("Could not open file: $filename\n$!");
  }

  @lines = <FILETABLE>;
  close FILETABLE;

  foreach (@lines) {                   # read next line from file
    chop;                              # remove \n, not tested with \r\n
    (my $name, my @info) = split /\t/;
    &storeInfo($table, $name, @info);
    if ($info[0] =~ /$filter/i) {      # file is HTML file
      push (@$ref_to_array, $name);    # store name in array
    }
  }
  &dumpFileTable;
}

sub GetHTMLFilenames {
  return @HTMLfilenames;
}

sub GetHTMLFiles {
  return @HTMLfiles;
}

sub GetFileTable {
  return @fileTable;
}

sub filecmp {
  my $name1 = $$files{$a}[0];
  my $name2 = $$files{$b}[0];
  eval($sortingCode) if $sortingFile;
  return (substr($name1, 0, index($name1, "index."))
	  cmp substr($name2, 0, index($name2, "index.")));
    # compare files up to "index."
}

sub dumpFileTable {
  &readSortingFile if ($sortingFile);
  my @keys = sort filecmp (keys %$files);
  # sort after full name
  foreach $key (@keys) {
    push @fileTable, ($key);
    if ((my $filename = $$files{$key}[0]) =~ /$filter/io) {
      if ($filename !~ /$hide/io or (!($hide))) {
	push @HTMLfiles, ($key);
	push @HTMLfilenames, ($filename);
      }
    }
  }
}

sub readSortingFile {
  unless (open(FILE, $sortingFile)) {
    &error("Could not open file: $sortingFile\n$!");
  }
  while (<FILE>) {
    next if /\#/;
    chop;
    my ($search, $replace) = split /\t/;
    $sortingCode .= "\$name1 =~ s~$search~$replace~;";
    $sortingCode .= "\$name2 =~ s~$search~$replace~;";
  }
  close FILE;
}
1;
