#########################################################################
# macros for HTML PLAIN
# (C) 1999 by Cyrille Artho, all rights reserved

sub DumpArgs {
  my $out;
  my $tmp;
  while ($tmp = shift @_) {$out .= $tmp; }
  return $out;
}

sub DoLink {
  # used internally, replaces link with redefined link
  my $link = shift;
  $link = "\"$link\"" if ($quoteVars);
  &store($vars, "LINK", $link);
  &store($vars, "NAME", shift);
  my $tag = &load($tags, "href");
  return ("<".&replaceVars($tag).">");
}

sub LinkTable {
  # makes hierachical link list - options: minimum/maximum content level of docs
  # starting tag for table, tags for starting new entry
  # 1) entry higher up the tree; 2) sibling entry; 3) child entry
  my $min = shift @_;
  if ($min < 0) { $min = 0; }
  my $max = shift @_;
  my ($table, $parent, $sibling, $child);
  unless ($table = shift @_) { $table = "<table>"; }
  unless ($parent = shift @_) { $parent = "<tr><td>"; }
  unless ($sibling = shift @_) { $sibling = "<tr><td>"; }
  unless ($child = shift @_) { $child = "<tr><td>"; }
  my $mode = shift @_;
  # last argument: mode: include size or not (bit 0)
  # bit1: unused
  # always include root node (bit 2)
  # link to siblings (bit 3)
  # link to siblings only if current and sibling page = index page (bit 4)
  $out = $table;
  my @files = &GetHTMLFiles;
  my $self = GetVar("SELF");
  my $mylevel = GetFileInfo(GetVar("THIS"), 2);
  my $check = $self;
  my $isIndex = $check =~ s/index.*//i; # remove index.html
  my $separator;
  $check =~ s/index.*//i;           # remove index.html
  foreach my $file (@files) {
    my $fullname = GetFileInfo($file, 0);
    my $level = GetFileInfo($file, 2);
    next unless ($fullname =~ /^$check/i or $level <= $mylevel);
    # file must be part of subtree or ancestor
    my $check2 = $fullname;
    my $isIndex2 = $check2 =~ s/index.*//i; # remove index.html
    if ($level < $mylevel) {
      if ($self =~ /^$check2/i) {      # file is direct ancestor
	PutVar('BACK', $file);
      } else {                         # file is "uncle", skip
	next;
      }
    }
    unless ($mode & 8) {               # link to siblings
      unless ($mode & 16 and $isIndex) { # if mode 4 set, more restrictive
	next if ($level == $mylevel and $fullname ne $self);
      }
      # don't link to siblings unless specified
    }
    if ($isIndex2) { # file is index.html, remove last directory
      $check2 =~ s/(.*\/).*?\/.*?/$1/;
    } else { # just remove basename
      $check2 =~ s/(.*\/).*/$1/;
    }
    if ($level <= $mylevel) {          # check for common parent
      next unless ($self =~ /^$check2/);
    }
    # only include direct ancestor
    # pages must be within sub-tree
    unless ($mode & 4 and $level == 0) {
      next unless ($level >= $min and $level <= $max);
    }
    my $size = GetFileInfo($file, 1);
    my $link = &adjustPath($self, $fullname);
    # insert new table line
    if ($level < $mylevel) {
      $separator = $parent;
    } elsif ($level == $mylevel) {
      $separator = $sibling;
    } else {
      $separator = $child;
    }
    if ($self eq $fullname) {
      $out .= "$separator$file";
    } else {
      $out .= $separator.DoLink($link, $file);
    }
    if ($mode & 1) { $out .= " ($size)"; }
    $out .= EndingTags($separator);
    $out.="\n";
  }
  $out .= EndingTags($table);
  return $out;
}

sub MakeLinks {
  # makes hierachical link list - options: minimum/maximum content level of docs
  # starting tag for one hierarchy deeper, separator tag for entries
  # (one before and one after each entry), ending tag
  # for lower hierarchy
  my $min = shift @_;
  if ($min < 0) { $min = 0; }
  my $max = shift @_;
  my $start = shift @_;
  my $out;
  my $separator;
  unless (defined($separator = shift @_)) { $separator = "<br>"; }
  my $endsep = shift @_;
  my $end = shift @_;
  my $mode = shift @_; 
  # last argument: mode: include size or not (bit 0)
  # repeat starting tags from 0 each time (bit 1)
  # always include root node (bit 2)
  # link to siblings (bit 3)
  # link to siblings only if current and sibling page = index page (bit 4)
  my @files = &GetHTMLFiles;
  my $self = GetVar("SELF");
  my $mylevel = GetFileInfo(GetVar("THIS"), 2);
  my $check = $self;
  my $cnt = 0;
  my $isIndex = $check =~ s/index.*//i; # remove index.html
  my $prevlevel = $min-1;
  foreach my $file (@files) {
    my $fullname = GetFileInfo($file, 0);
    my $level = GetFileInfo($file, 2);
    next unless ($fullname =~ /^$check/i or $level <= $mylevel);
    # file must be part of subtree or ancestor
    my $check2 = $fullname;
    my $isIndex2 = $check2 =~ s/index.*//i; # remove index.html
    if ($level < $mylevel) {
      if ($self =~ /^$check2/i) {      # file is direct ancestor
	PutVar('BACK', $file);
      } else {                         # file is "uncle", skip
	next;
      }
    }
    unless ($mode & 8) {               # link to siblings
      unless ($mode & 16 and $isIndex) { # if mode 4 set, more restrictive
	next if ($level == $mylevel and $fullname ne $self);
      }
      # don't link to siblings unless specified
    }
    if ($isIndex2) { # file is index.html, remove last directory
      $check2 =~ s/(.*\/).*?\/.*?/$1/;
    } else { # just remove basename
      $check2 =~ s/(.*\/).*/$1/;
    }
    if ($level <= $mylevel) {          # check for common parent
      next unless ($self =~ /^$check2/);
    }
    # only include direct ancestor
    # pages must be within sub-tree
    unless ($mode & 4 and $level == 0) {
      next unless ($level >= $min and $level <= $max);
    }
    if ($mode & 2) {
      for (my $i = $min; $i < $level; $i++) {
	$out .= $start;
      }
    } else {
      if ($level > $prevlevel) {
	for (my $i = $level; $i > $prevlevel; $i--) {
	  $out .= $start; $cnt++;
	}
      }
      elsif ($level < $prevlevel) {
	for (my $i = $level; $i < $prevlevel; $i++) {
	  $out .= $end; $cnt--;
	}
      }
    }
    $prevlevel = $level;
    my $size = GetFileInfo($file, 1);
    my $link = &adjustPath($self, $fullname);
    if ($self eq $fullname) {
      $out .= "$separator$file";
    } else {
      $out .= $separator.DoLink($link, $file);
    }
    if ($mode & 1) { $out .= " ($size)"; }
    if ($mode & 2) {
      for (my $i = $min; $i < $level; $i++) {
	$out .= $end;
      }
    }
    $out.="$endsep\n";
  }
  unless ($mode & 2) {
    for ( my $i = 0; $i < $cnt; $i++) {
      $out .= $end;
    }
  }
  return $out;
}

sub SiteMap {
  # site map of the whole page; args: start of new level, separator for entries,
  # end of level, mode 
  # mode: bit 0 = include file size
  # bit 1 = don't print separator at beginning
  my $start = shift @_;
  my $out;
  my $separator;
  unless ($separator = shift @_) { $separator = "<br>"; }
  my $end = shift @_;
  my $mode = shift @_;                 # last argument: include size or not
  my @files = &GetHTMLFiles;
  my $self = GetVar("SELF");
  my $prevlevel = -1;
  foreach my $file (@files) {
    my $fullname = GetFileInfo($file, 0);
    my $level = GetFileInfo($file, 2);
    if ($level > $prevlevel) {
      for (my $i = $level; $i > $prevlevel; $i--) {
	$out .= $start;
	$cnt++;
      }
    }
    elsif ($level < $prevlevel) {
      for (my $i = $level; $i < $prevlevel; $i++) {
	$out .= $end;
	$cnt--;
      }
    }
    $prevlevel = $level;
    my $size = GetFileInfo($file, 1);
    my $link = adjustPath($self, $fullname);
    if ($mode & 2) { $mode = $mode & (~2); }
    else {
      $out .= $separator;
    }
    $out .= DoLink($link, $file);
    if ($mode & 1) { $out .= "($size)"; }
    $out.="\n";
  }
  for ( my $i = 0; $i < $cnt; $i++) {
    $out .= $end;
  }
  return $out;
}

sub DataLinks {
  # links to other .data generated html files
  # end of level, mode 
  # mode: bit 1 = don't print separator at beginning
  # Assumption: title ends with some counter value (number)

  my $start = shift @_;
  my $out;
  my $separator;
  unless ($separator = shift @_) { $separator = "<br>"; }
  my $end = shift @_;
  my $href;
  unless ($href = shift @_) { $href = "a href="; }
  my $title;
  unless ($title = shift @_) { $title = GetVar('THIS'); }
  my $mode = 2;

  my @files = &GetHTMLFiles;
  my $self = GetVar("SELF");
  my $prevlevel = -1;
  my $titleStart = $title;
  $titleStart =~ s/(\D*)\d+$/$1/;      # take everything *up to* first number
  foreach my $file (@files) {
    my $file2 = $file;
    next unless ($file2 =~ s/$titleStart//i);
    my $fullname = GetFileInfo($file, 0);
    my $level = GetFileInfo($file, 2);
    if ($level > $prevlevel) {
      for (my $i = $level; $i > $prevlevel; $i--) {
	$out .= $start;
	$cnt++;
      }
    }
    elsif ($level < $prevlevel) {
      for (my $i = $level; $i < $prevlevel; $i++) {
	$out .= $end;
	$cnt--;
      }
    }
    $prevlevel = $level;
    my $size = GetFileInfo($file, 1);
    my $link = adjustPath($self, $fullname);
    if ($mode & 2) { $mode = $mode & (~2); }
    else {
      $out .= $separator;
    }
    $out .= "<$href\"$link\">$file2<";
    $out .= closingTags($href);
    $out.=">\n";
  }
  for ( my $i = 0; $i < $cnt; $i++) {
    $out .= $end;
  }
  return $out;
}

sub Back {
  # link back to parent page
  my $text = shift @_; # link text
  my $self = GetVar("SELF");
  my $out = $niltext;
  my $file;
  if ($file = GetVar("BACK")) {       # macro has found parent, use it
    my $link = adjustPath($self, GetFileInfo($file, 0));
    return DoLink($link, "$text $file");
  }
  my @files = &GetHTMLFiles;
  my $parent = $self;
  if ($parent =~ s/index\..*//i) { # file is index.html, remove last directory
    $parent =~ s/(.*\/).*?\/.*?/$1/;
  } else { # just remove basename
    $parent =~ s/(.*\/).*/$1/;
  }
  my $mylevel = GetFileInfo(GetVar("THIS"), 2);
  $mylevel--;
  foreach $file (@files) {
    my $fullname = GetFileInfo($file, 0);
    next unless $fullname =~ /^$parent/i;
#    print "$this - $self - $fullname\n";
    my $level = GetFileInfo($file, 2);
    if ($level == $mylevel) {
      my $link = adjustPath($self, $fullname);
      return DoLink($link, "$text $file");
    }
  }
  return $out;
}

sub LinkTo {
  # creates a correct relative link to target URL
  my $URL = shift @_;
  my $text;
  my $self = GetVar("SELF");
  my $link = adjustPath($self, $URL);
  unless ($text = shift @_) { $text = $link; }
  return DoLink($link, $text);
}

sub Prev {
  # link to previous page of same content level, if any
  my $text = shift @_;
  my $niltext = shift; # text for empty link (optional)
  my $self = GetVar("SELF");
  my $file;
  my @files = &GetHTMLFiles;
  #return $niltext if $self =~ /index\./i; # ignore index pages
  my $parent = $self;
  if ($parent =~ s/index\..*//i) { # file is index.html, remove last directory
    $parent =~ s/(.*\/).*?\/.*?/$1/;
    $isindex = 1;
  } else { # just remove basename
    $parent =~ s/(.*\/).*/$1/;
  }
  my $this = GetVar('THIS');
  my $mylevel = GetFileInfo($this, 2);
  my ($prevname, $prev);
  foreach $file (@files) {
    my $filename = GetFileInfo($file, 0);
    next unless ($isindex == $filename =~ /index\./i);
    if ($file eq $this) {
      my $level = GetFileInfo($prev, 2);
      if ($prevname and $level == $mylevel and $prevname =~ /$parent/) {
	my $link = adjustPath($self, $prevname);
	return DoLink($link, "$text $prev");
      } else {
	return $niltext; # for first file
      }
    }
    $prev = $file;
    $prevname = $filename;
  }
  return $niltext;
}


sub Next {
  # link to next page of same content level, if any
  my $text = shift @_;
  my $niltext = shift; # text for empty link (optional)
  my $self = GetVar("SELF");
  my $parent = $self;
  if ($parent =~ s/index\..*//i) { # file is index.html, remove last directory
    $parent =~ s/(.*\/).*?\/.*?/$1/;
    $isindex = 1;
  } else { # just remove basename
    $parent =~ s/(.*\/).*/$1/;
  }
  my $file;
  my @files = &GetHTMLFiles;
  $isindex = $self =~ /index\./i;
  my $this = GetVar('THIS');
  my $mylevel = GetFileInfo($this, 2);
  my $found = 0;
  foreach $file (@files) {
    my $filename = GetFileInfo($file, 0);
    next unless ($isindex == $filename =~ /index\./i);
    if ($found) {
      my $level = GetFileInfo($file, 2);
      if ($level == $mylevel and $filename =~ /$parent/) {
	my $link = adjustPath($self, GetFileInfo($file, 0));
	return DoLink($link, "$text $file");
      } else {
	return $niltext; # for first file
      }
    }
  if ($file eq $this) {
      $found = 1;
    }
  }
  return $niltext;
}

sub LinkTo {
  # creates a correct relative link to target URL
  my $URL = shift @_;
  my $text;
  my $self = GetVar("SELF");
  my $link = adjustPath($self, $URL);
  unless ($text = shift @_) { $text = $link; }
  return DoLink($link, $text);
}

sub Pictures {
  # show all pictures within a certain pathname, in a table
  my $path = shift @_;
  $path =~ s/index\..*//i;
  my $cols;
  unless ($cols = shift @_) { $cols = 2; }
  my $self = GetVar("SELF");
  my $n = 0;
  my @files = &GetFileTable;
  my $out = "<table border=\"0\">\n";
  foreach my $file (@files) {
    my $fullname = GetFileInfo($file, 0);
    if ($fullname =~ /$imageFilter/io and $fullname =~ /$path/i) {
      if (($n % $cols) == 0) {
	if ($n > 0) { $out .= "</tr>\n"; }
	$out .= "<tr>";
      }
      $out .= "<td>";
      my $format = GetFileInfo($file, 2);
      ($width, $height) = split /x/, $format;
      my $size = GetFileInfo($file, 1);
      my $link = adjustPath($self, $fullname);
      $out .= "<img src=\"$link\" alt=\"$file ($size)\" width=\"$width\" height=\"$height\"></td>\n";
      $n++;
    }
  }
  return "$out\n</tr></table>\n";
}

sub Trc {
  my $color = shift;
  my $flag = GetVar('__TR_BG_FLAG__');
  $flag = 1-$flag;
  PutVar('__TR_BG_FLAG__', $flag);
  if ($flag) {
    return '<tr>';
  } else {
    return "<tr bgcolor=\"$color\">";
  }
}

sub Date {
  return "Date";
}

sub Test {
  return "Test";
}
1;
