#!/usr/bin/wish
###################################################
# Demo for different config tools
# by Cyrille Artho, distributed under the GPL

proc config1 { } {
    catch {exec config.tcl &}
}

proc config2 { } {
    catch {exec config2.tcl &}
}

proc variable { } {
    catch {exec variables.tcl &}
}

proc template { } {
    catch {exec template.tcl &}
}

proc filetable { } {
    set err [catch {set out [exec plainfiles]}]
    if $err {
	puts stderr "Error $err occured.\n"
    } else {
	tk_messageBox -type ok -message "Filetable updated successfully." \
	    -title "Done." -icon info
    }
}

proc parser { } {
    set err [catch {set out [exec htmlplain]}]
    if $err {
	puts stderr "Error $err occured.\n"
    } else {
	tk_messageBox -type ok -message "Precompiler ran successfully." \
	    -title "Done." -icon info
    }
}

wm title . "Webtools"
# create frames to hold content
frame .menubar
set menubar .menubar
set padding 2
event add <<C1>> <Meta-1> <Alt-1> <Control-1> <Command-1> <Key-1>
event add <<C2>> <Meta-2> <Alt-2> <Control-2> <Command-2> <Key-2>
event add <<Var>> <Meta-v> <Alt-v> <Control-v> <Command-v> <v> <V>
event add <<Tpl>> <Meta-t> <Alt-t> <Control-t> <Command-t> <t> <T>
event add <<Exit>> \
	<Meta-x> <Alt-x> <Control-x> <Control-c> <Command-period> <x> <X>
bind . <<Exit>> exit
bind . <<C1>> { config1 }
bind . <<C2>> { config2 }
bind . <<Var>> { variable }
bind . <<Tpl>> { template }

label $menubar.title -text "Options for HTML PLAIN" \
    -relief solid -padx 4 -pady 4 -borderwidth 2
grid $menubar.title -columnspan 2 -pady 5 -padx 5

# create all menu buttons

foreach { name label pos } \
    { config1 "Configurator 1" 13 config2 "Configurator 2" 13 \
      variable "Variable Editor" 0 template "Template editor" 0 \
	  filetable "Build new filetable" 10 parser "Run precompiler" 4 \
      exit Exit 1 } {
	button $menubar.$name -text $label -command $name -underline $pos
    }

foreach { name label } \
    { config1 "Classic version" config2 "Spreadsheet version" \
	  variable "including new color picker" \
	  template "including syntax coloring" \
	  filetable "Use if new files have been added" \
	  parser "Run after configuration and filetable" \
	  exit "Leave program"} {
	      label $menubar.l$name -text $label
	      grid $menubar.$name $menubar.l$name -sticky w
	      grid $menubar.$name -sticky ew
}

pack $menubar
