#!/usr/bin/perl
###################################################
# Parser for HTML templates v1.1
# written in 1998/9 by Cyrille Artho, published under the GPL

my ($currentTag, $currentRdef, $comment, $tag, $redefinition, $tags);

sub parseTemplate { # args: filename, ref_to_entities, ref_to_tags
  $line = 0;                           # global line counter
  $currentTag = "";                    # current HTML tag (for multi line def.)
  $currentRedef = "";                  # current redefinition
  $currStatus;
  $comment = 0;                        # flag for C comment mode
  $tag = ""; $redefinition = "";       # tag and redefinition
  $fileName = shift @_;
  my $entities = shift @_; 
  $tags = shift @_;
    
  unless (open(TEMPLATE, $fileName)) {
    &error("Could not open file: $fileName\n$!");
  }

  my @template = <TEMPLATE>;
  close TEMPLATE;

  foreach $_ (@template) {             # read next line from file
    $line++;
    chop;
    next if /^\#/;                     # ignore line with Perl (#) or ...
    next if /^\/\//;                   # C++ style comments (//)
    &comments;
    next if /^\s*$/;                   # ignore empty lines or whitespace only
    
    &quoteLine;                        # escape sequences \\, \t, \/ etc. #
    my $status = &splitTemplateLine;
    
    # check whether &entity; or <tag> or tag and add it to the right hash
    
    if ($tag =~ s/^&(.*);$/$1/) { # HTML &entity; remove & and ;
      # if trailing ; missing it is falsely assumed that &entity is an HTML tag
      $tag=lc($tag);                   # convert to lowercase
      &store($entities, $tag, $redefinition); # store entity => redefinition
    }
    else {                             # assume <tag> or tag
      if ($tag) {                      # no continued multi line definition
	$tag =~ s/^<//;
	$tag =~ s/>$//;                # strip angular brackets, if any
	if ($currentTag) { &redefinition; }
	$currentTag = $tag;            # new definition
	$currentStatus = $status;
	$redefinition =~ s/^<//;       # remove < at beginning of line
	### don't $redefinition =~ s/>$//;       # remove > at end of line
	$currentRedef = $redefinition;
      }
      else {                           # cont'd multi line redefinition
	unless ($currentRedef =~ s/\\$//) {  # \ at end of line, no line break
	  $currentRedef .= "\n";       # otherwise add newline
	}
	$currentRedef .= $redefinition; # simply extend redefinition by one line
      }
    }
  }
  if ($currentTag) { &redefinition; }
}

sub redefinition {
  $currentRedef =~ s/>$//; # remove trailing > in last multi line redef.
  $currentRedef = "<" . $currentRedef . ">";
  $old =  $currentRedef;
  $currentRedef = &replaceVars($currentRedef);
  $currentRedef = &replaceTags($currentRedef); # recursive defs
  $currentRedef =~ s!<//!</!g; # <// tags may be caused by recursive defs, fix
  if ($currentTag eq "^") {
    $header = lc(&breakUpTags($currentRedef, \@header, \%headerLines));
  }
  if ($currentTag eq "\$") {
    $footer = lc(&breakUpTags($currentRedef, \@footer, \%footerLines));
  }
  else {
    $currentRedef =~ s/^<//;
    $currentRedef =~ s/>$//;     # strip angular brackets (again...)
    # should be changed in final version (some small overhead)
  }
  &store($tags, $currentTag, $currentRedef);
  &store($tag_status, $currentTag, $currentStatus);
} # store old (possible multi line) pair tag -> redefinition

sub comments {                         # handle C comments /*...*/ 
  if (/\/\*/) {                        # C comment found
      $_ = $`;                         # take prematch=everything before comment
      $comment = 1;
    }
  while ($comment) {                   # check for ending comment */
    if (!(/\*\//)) {                   # no ending comment
      $_ = "";
      return;
    }
    else {
      $_ = $';                         # take postmatch=everything after comment
      $comment = 0;
    }
    if (/\/\*/) {                      # C comment found
      $_ = $`;                         # take prematch=everything before comment
      $comment = 1;
    }
  }
}

sub splitTemplateLine {
  my $comment;
  $n= ($tag, $redefinition, $comment) = split /\t/; # split string up
  unless ($n) {                        # no tab character at all, error
    &error ("No tab character found.");
  }
  unless ($currentTag or $n>1) {       # no tag defined yet, only one tab
    &error ("Multi line definition without prior definition of tag.");
  }
  return ($comment =~ /^\#!/);
}

1;
