# the procedures controlling the behavior of the two list boxes
# and the scroll bar are taken from
# "Practical programming in Tcl and Tk" from B. Welch
# Bind_Select has been written for this special purpose

proc Scroll_Set {scrollbar geoCmd offset size} {
    if {$offset != 0.0 || $size != 1.0} {
	eval $geoCmd			;# Make sure it is visible
	$scrollbar set $offset $size
    } else {
	set manager [lindex $geoCmd 0]
	$manager forget $scrollbar
	# hide it
    }
}

proc BindSelect { y args } {
    foreach w $args {
	$w select clear 0 end
	$w select anchor [$w nearest $y]
	$w select set anchor [$w nearest $y]
    }
}

proc BindYView { lists args } {
    # scroll both listboxes simultaneously
    foreach l $lists {
	eval {$l yview} $args
    }
}

proc BindDragto { x y args } {
	foreach w $args {
		$w scan dragto $x $y
	}
}
proc BindMark { x y args } {
	foreach w $args {
		$w scan mark $x $y
	}
}

proc Bind_Display { frame } {
	$frame.variables delete 0 end
	$frame.values delete 0 end
	foreach seq [bind variable] {
		$frame.variables insert end $seq
		$frame.values insert end [bind variable $seq]
	}
}

proc Bind_Select { y lbox input } {
    BindSelect $y $lbox.variables $lbox.values
    set line [$lbox.variables curselection]
    handleSelection $line $lbox $input
}

proc KeySelect { listbox lbox input } {
    set line [$listbox curselection]
    if { [llength $line] == 0 } {
	# undefined selection
	set line [$listbox index active]
    }
    handleSelection $line $lbox $input
    focusInput2
}

proc fixSelection { listbox body input inc } {
    set line [$listbox curselection]
    if { $line == "" } {
	set line 0
    }
    incr line $inc
    if { $line < 0 } {
	set line 0
    } elseif { $line >= [$listbox index end] } {
	set line [$listbox index end]
	incr line -1
    }
    $body.variables selection clear 0 end
    $body.variables see $line
    $body.variables activate $line
    $body.variables selection set $line
    $body.values selection clear 0 end
    $body.values see $line
    $body.values activate $line
    $body.values selection set $line
    handleSelection $line $body $input
    return -code break
    # don't do default code
}

proc SeeAndActivate { lbox line } {
    # makes sure only one entry is selected in both listboxes
    $lbox.variables selection clear 0 end
    $lbox.variables see $line
    $lbox.variables activate $line
    $lbox.variables selection set $line
    $lbox.variables selection anchor $line
    $lbox.values selection clear 0 end
    $lbox.values see $line
    $lbox.values activate $line
    $lbox.values selection set $line
    $lbox.values selection anchor $line
}
