#!/usr/bin/perl
###################################################
# Parser for variable dictionaries v0.2
# (C) 1998 by Cyrille Artho, all rights reserved

my ($var, $content);

sub parseVariables { # args: filename, ref_to_variables
  $line = 0;                           # global line counter
  
  unless (open(VARIABLES, $_[0])) {
    &error("Could not open file: $_[0]\n$!");
  }

  my $vars = $_[1];                    # evaluate other args

  @lines = <VARIABLES>;
  close VARIABLES;

  foreach $_ (@lines) {                # read next line from file
    $line++;
    chop;                              # remove \n, not tested with \r\n
    next if /^\s*$/;                   # ignore empty lines or whitespace only
    next if /^\#/;                     # ignore line with Perl (#) or ...
    next if /^\/\//;                   # C++ style comments (//)
    
    ####################################
    # escape sequences \\, \t, \/ etc. #
    ####################################
    
    &splitVarLine;
    $var = &variableName($var);        # allow only alnum's in variable names
    
    $content = &replaceVars($content); # recursive def's
    &store($vars, $var, $content); 
    # store variable => content after replacing strings in content
  }
}

sub splitVarLine {
  unless (($var, $content) = split /\t/) { # split string up
    &error ("No tab character found.");# no tab character at all, error
  }
}

1;
